<?php

class ShowSimilarThreads_ControllerPublic_Forum extends XFCP_ShowSimilarThreads_ControllerPublic_Forum
{
	public function actionSimilarThreads()
	{
		$this->_assertPostOnly();
		
		$forumId = $this->_input->filterSingle('node_id', XenForo_Input::UINT);
		$forumName = $this->_input->filterSingle('node_name', XenForo_Input::STRING);

		$ftpHelper = $this->getHelper('ForumThreadPost');
		$forum = $ftpHelper->assertForumValidAndViewable($forumId ? $forumId : $forumName);

		$forumId = $forum['node_id'];
		
		$query = $this->_input->filterSingle('query', XenForo_Input::STRING);
		
		$similarThreads = array();
		if ($query)
		{
			$similarThreads = $this->getSimilarThreadsModel()->getSimilarThreads($forum, $query);
		}
		
		$viewParams = array(
			'nodeBreadCrumbs' => $ftpHelper->getNodeBreadCrumbs($forum),
			'forum' => $forum,
			'similarThreads' => $similarThreads,
			'showDismiss' => true
		);
		
		return $this->responseView(
			'ShowSimilarThreads_ViewPublic_SimilarThreads',
			'similar_threads',
			$viewParams
		);
	}
	
	public function getSimilarThreadsModel()
	{
		return $this->getModelFromCache('ShowSimilarThreads_Model_SimilarThreads');
	}
}

?>